/*
 * Decompiled with CFR 0.152.
 */
package org.betterx.bclib.commands.arguments;

import com.mojang.serialization.Codec;
import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;

public enum PlacementDirections implements StringRepresentable
{
    NORTH_OF("northOf", Float3.NORTH, PlacementDirections::resetStartNorthSouth),
    EAST_OF("eastOf", Float3.EAST, PlacementDirections::resetStartEastWest),
    SOUTH_OF("southOf", Float3.SOUTH, PlacementDirections::resetStartNorthSouth),
    WEST_OF("westOf", Float3.WEST, PlacementDirections::resetStartEastWest),
    ABOVE("above", Float3.UP, PlacementDirections::resetStartEastWest),
    BELOW("below", Float3.DOWN, PlacementDirections::resetStartEastWest),
    AT("at", null, null);

    public static final Codec<PlacementDirections> CODEC;
    private final String name;
    public final Float3 dir;
    private final ResetStart resetStart;

    private static Float3 resetStartNorthSouth(Bounds totalBounds, BlockPos lastStart, int offset) {
        return Float3.of((double)(totalBounds.max.x + (double)offset), (double)lastStart.m_123342_(), (double)lastStart.m_123343_());
    }

    private static Float3 resetStartEastWest(Bounds totalBounds, BlockPos lastStart, int offset) {
        return Float3.of((double)lastStart.m_123341_(), (double)lastStart.m_123342_(), (double)(totalBounds.max.z + (double)offset));
    }

    private PlacementDirections(String name, Float3 dir, ResetStart resetStart) {
        this.name = name;
        this.dir = dir;
        this.resetStart = resetStart;
    }

    public BlockPos getOffset() {
        return this.dir == null || this.dir == Float3.ZERO ? null : this.dir.toBlockPos();
    }

    public int sizeInDirection(Bounds totalBounds) {
        return (int)totalBounds.getSize().mul(this.dir).length();
    }

    public BlockPos advanceStart(Bounds placedBound, BlockPos lastStart) {
        return this.advanceStart(placedBound, lastStart, 1);
    }

    public BlockPos advanceStart(Bounds placedBound, BlockPos lastStart, int offset) {
        return lastStart.m_121955_((Vec3i)this.dir.mul((double)(this.sizeInDirection(placedBound) + offset)).toBlockPos());
    }

    public BlockPos resetStart(Bounds totalBounds, BlockPos lastStart) {
        return this.resetStart(totalBounds, lastStart, 3);
    }

    public BlockPos resetStart(Bounds totalBounds, BlockPos lastStart, int offset) {
        if (this.resetStart == null) {
            return lastStart;
        }
        return this.resetStart.calculate(totalBounds, lastStart, offset).toBlockPos();
    }

    public String m_7912_() {
        return this.name;
    }

    static {
        CODEC = StringRepresentable.m_216439_(PlacementDirections::values);
    }

    static interface ResetStart {
        public Float3 calculate(Bounds var1, BlockPos var2, int var3);
    }
}

